/*********************************************************************/
/* Project Name: SPI_Master.mcp                                      */
/* Source fle name: SPI_Master.c                                     */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: SPI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: In this lab, always is sending a byte by SPI to      */
/* another MCU (slave).                                              */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned char UINT8;        
typedef unsigned int UINT16;

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
  SOPT1 = 0x23;          /* Watchdog disable */  
  SCGC1 = 0x00;          /* Disable Bus clock to unused peripherals */
  SCGC2 = 0x02;          /* Bus Clock to the SPI2 module is enabled */
}

void GPIO_Init(void) { 
 
  PTDDD = 0x04;          /* The SS signal must be generated by software using a GPIO */
  PTCDD = (UINT8) (PTCD | 0x3F);    /* Configure PTC0-PTC5 as outputs */
  PTEDD = (UINT8) (PTED | 0xC0);    /* Configure PTE6 and PTE7 pins as outputs */
  PTCD = 0x3F;           /* Put 1's in port C in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in port E in order to turn off the LEDs */

}

void SPI_configuration (void) {
 
  SPI2BR = 0x75;        /* Select the highest baud rate prescaler divisor and the highest baud rate divisor */
  SPI2C1 = 0xD2;        /* SPI Interrupt enable, system enable and master mode selected */ 
  SPI2C2 = 0x10;        /* Different pins for data input and data output */
} 

void delay (UINT16 a) {

  UINT16 i = 0;
  for (i; i<=a; i++){            
  }      
}
/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  UINT8 counter = 0;
  
  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  SPI_configuration();  /* Function that initializes the SPI module */

  EnableInterrupts; /* enable interrupts */
  
  for(;;) {

  delay(60000);            /* Delay function */
  while (!SPI2S_SPTEF && !PTDD_PTDD3);  /* Wait until transmit buffer is empty */
  PTDD_PTDD3 = 0;          /* Slave Select set in low */
  SPI2D = counter;         /* Put in SPI buffer a data to send */
  PTED = (UINT8) (~counter & 0xC0);    /* Move counter value to port E */
  PTCD = (UINT8) (~counter & 0x3F);    /* Move counter value to port C */
  counter++;               /* Increment counter */

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    

void interrupt VectorNumber_Vspi2 SPI_ISR(void) {

 UINT8 temp;

 while (PTDD_PTDD0);   /* Wait for clock to return no default */
 PTDD_PTDD3 = 1;       /* Set Slave Select high */
 temp = SPI2S;         /* Clear register flag */
 temp = SPI2D;				 /* Read data register to clear receive flag */
} 

